<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePackageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return user()->can('package-add');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'adult_price' => 'required|numeric|min:0',
            'child_price' => 'required|numeric|min:0',
            'infant_price' => 'required|numeric|min:0',
            'category_id' => 'required|exists:categories,id',
            'destination_id' => 'required|exists:destinations,id',
            'pickup_point' => 'required|string|max:255',
            'start_point' => 'required|string|max:255',
            'end_point' => 'required|string|max:255',
            'min_people' => 'required|integer|min:1',
            'max_people' => 'required|integer|min:1|gte:min_people',
            'duration' => 'required|string|max:255',
            'video' => 'nullable|url',
            'inclusions' => 'nullable|array',
            'inclusions.*' => 'required|string|max:255',
            'exclusions' => 'nullable|array',
            'exclusions.*' => 'required|string|max:255',
            'we_expect' => 'nullable|array',
            'we_expect.*' => 'required|string|max:255',
            'description' => 'required|string',
            'status' => 'nullable|boolean',
            'published' => 'nullable|boolean',
            'featured' => 'nullable|boolean',
            'thumbnail' => 'required|image|mimes:jpeg,png,jpg|max:1024',
            'gallery' => 'required|array',
            'gallery.*' => 'required|image|mimes:jpeg,png,jpg|max:1024',
            'start_date' => 'nullable|date|after_or_equal:today',
        ];
    }
}
